<?php

namespace Mtc\ShippingManager\Events;

use Mtc\ShippingManager\Http\Requests\SetDeliveryMethodRequest;
use Mtc\Basket\Contracts\BasketRepositoryInterface;

/**
 * Class SetDeliveryForBasket
 * @package Mtc\ShippingManager\Events
 */
class SetDeliveryForBasket
{
    /**
     * @var SetDeliveryMethodRequest
     */
    protected $request;

    /**
     * @var \Illuminate\Database\Eloquent\Model
     */
    protected $basket;

    /**
     * @var BasketRepositoryInterface
     */
    protected $basket_repository;

    /**
     * SetDeliveryForBasket constructor.
     *
     * @param SetDeliveryMethodRequest $request
     * @param BasketRepositoryInterface $basket
     */
    public function __construct(SetDeliveryMethodRequest $request, BasketRepositoryInterface $basket_repository)
    {
        $this->request = $request;
        $this->basket = $basket_repository->getModel();
        $this->basket_repository = $basket_repository;
    }

    /**
     * Get basket repository
     *
     * @return BasketRepositoryInterface
     */
    public function getBasketRepository() {
        return $this->basket_repository;
    }

    /**
     * @return \Illuminate\Database\Eloquent\Model|BasketRepositoryInterface
     */
    public function getBasket() {
        return $this->basket;
    }

    /**
     * Get request
     *
     * @return SetDeliveryMethodRequest
     */
    public function getRequest()
    {
        return $this->request;
    }
}