<?php

namespace Mtc\ShippingManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Mtc\Orders\OrderShipment;
use Mtc\ShippingManager\Facades\Courier;

/**
 * Class DispatchOrderToCourier
 *
 * @package App\Jobs
 */
class DispatchShipmentToCourier implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * @var OrderShipment
     */
    protected $shipment;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($shipment)
    {
        $this->shipment = $shipment;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        Courier::send($this->shipment);
    }
}
