<?php

namespace Mtc\ShippingManager\Listeners;

use Illuminate\Support\Facades\Log;
use Mtc\Core\Admin\User;
use Mtc\Orders\Events\ShipmentSaved;
use Mtc\Orders\OrderShipment;

/**
 * Class UpdateOrderStatusFromShipment
 *
 * @package Mtc\ShippingManager
 */
class UpdateOrderStatusFromShipment
{
    /**
     * @param ShipmentSaved $event
     */
    public static function handle(ShipmentSaved $event)
    {
        if (empty(config('courier.updated_order_status')) || self::isInvalidShipment($event->shipment) === false) {
            return;
        }

        $status_name = config('courier.updated_order_status');
        $new_status_id = config("orders.statuses.{$status_name}");
        if (empty($new_status_id)) {
            Log::warning("Unable to find order status {$status_name}" );
            return;
        }

        $dummy_admin = new User([ 'name' => 'Courier' ]);
        $event->shipment->order->changeStatus($new_status_id, $dummy_admin);
    }

    /**
     * @param $shipment
     * @return bool
     */
    protected static function isInvalidShipment($shipment): bool
    {
        return empty($shipment->tracking_number)
            || $shipment->status != OrderShipment::STATUS_COMPLETED;
    }
}
