<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDeliveryCourierTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('delivery_couriers', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('api_courier_id');
            $table->integer('collect_location_id');
            $table->boolean('active');
            $table->string('username');
            $table->string('password');
            $table->string('account_number');
            $table->string('shipper_account')->nullable();
            $table->string('billing_account')->nullable();
            $table->string('duty_account')->nullable();
            $table->string('shipper_id')->nullable();
            $table->string('shipper_account_number')->nullable();
            $table->integer('pickup_delay_days');
            $table->string('pickup_time_window_start');
            $table->string('pickup_time_window_end');
            $table->integer('package_weight_threshold');
            $table->integer('default_package_length')->default(0);
            $table->integer('default_package_width')->default(0);
            $table->integer('default_package_height')->default(0);
            $table->string('label_format');
            $table->timestamps();

            $table->index('api_courier_id');
            $table->index('active');
        });

        Schema::create('delivery_courier_collect_locations', function (Blueprint $table) {
            $table->increments('id');
            $table->string('contact_name');
            $table->string('contact_phone', 50);
            $table->string('contact_email');
            $table->string('organisation');
            $table->string('address1');
            $table->string('address2');
            $table->string('city');
            $table->string('county');
            $table->string('postcode', 50);
            $table->string('country', 3);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('delivery_couriers');
        Schema::dropIfExists('delivery_courier_collect_locations');
    }
}