<?php

namespace Mtc\ShippingManager\Contracts;

use Illuminate\Support\Collection;
use Mtc\Basket\Contracts\BasketRepositoryInterface;

/**
 * Interface DeliveryMethodContract
 *
 * @package Mtc\ShippingManager
 */
interface DeliveryMethodContract
{
    /**
     * Retrieve methods that are applicable to basket
     *
     * @param BasketRepositoryInterface $basket
     */
    public function methodsForBasket(BasketRepositoryInterface $basket);

    public function setActiveMethod(BasketRepositoryInterface $basket, Collection $locations);

    public function hasMethods(): bool;
}
