<?php

namespace Mtc\ShippingManager;

/**
 * Class Country
 *
 * @package Mtc\Plugins\ShippingManager\Classes
 */
class Country extends \Mtc\Core\Models\Country
{
    /**
     * Relationship with zones that have this country
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function zone()
    {
        return $this->belongsToMany(Zone::class, 'shipping_zone_countries', 'country_id', 'zone_id');
    }
}
