<?php

namespace Mtc\ShippingManager\Discount;

use Mtc\ShippingManager\TableRate;
use Mtc\Money\Price;
use Mtc\Money\HasPrices;
use Illuminate\Support\Facades\App;

/**
 * Class Discount
 * @package Mtc\ShippingManager\Discount
 */
class Discount extends TableRate
{
    use HasPrices;

    /**
     * Get name attribute
     *
     * @return mixed
     */
    public function getNameAttribute()
    {
        return __('shipping_manager::discount.name');
    }

    /**
     * @return mixed
     * @throws \Exception
     */
    public function getAmountAttribute()
    {
        if (empty($this->price_models['amount'])) {
            $price = new Price($this->applicableToBasket(App::make('basket')));
            $price->calculate();
            $this->price_models['amount'] = $price;
        }

        return $this->price_models['amount'];
    }

    /**
     * Get the applicable amount on basket
     *
     * @param $basket
     * @return mixed
     */
    public function applicableToBasket($basket)
    {
        $this->deductable_amount = $basket->getCostSubtotalAttribute();
        App::make(config('shipping_manager.discount_type'))->apply($this, $basket);
        return $this->discounted_amount;
    }

    /**
     * Check if discount is available for basket
     *
     * @param $basket
     * @return bool
     */
    public function availableForBasket($basket)
    {
        return App::make(config('shipping_manager.discount_validation.basket'))->validate($this, $item);
    }

    /**
     * Check if there are items available for discount
     *
     * @param $items
     * @return bool
     */
    public function availableForItems($items)
    {
        $discountable_items = $items->filter(function ($item) {
            return $this->availableForItem($item);
        })->count();

        return (bool)$discountable_items;
    }

    /**
     * Check if discount is available for item
     *
     * @param $basket
     * @return bool
     */
    public function availableForItem($item)
    {
        return App::make(config('shipping_manager.discount_validation.item'))->validate($this, $item);
    }
}
