<?php

namespace Mtc\ShippingManager\Http\Controllers\Admin;

use Mtc\ShippingManager\Http\Requests\BasicShipmentExportRequest;
use Mtc\ShippingManager\Jobs\DispatchShipmentToCourier;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Orders\Order;
use Mtc\Orders\OrderShipment;

/**
 * Class ExportShipmentController
 *
 * @package Mtc\ShippingManager
 */
class BasicShipmentExportController extends Controller
{
    public function __invoke(BasicShipmentExportRequest $request, Order $order, OrderShipment $shipment)
    {
        $shipment->boxes()->delete();
        for ($i = 0; $i < $request->input('box_count'); $i++) {
            $shipment->boxes()
                ->create([
                    'box_id' => 0,
                    'weight' => $request->input('weight') / $request->input('box_count')
                ]);
        }
        $shipment->shipment_value = $request->input('shipment_value');
        $shipment->service_id = $request->input('service_id');
        $shipment->save();

        if ($shipment->validates()) {
            $this->dispatch(new DispatchShipmentToCourier($shipment));
            session()->flash('messages', [
                'type' => 'success',
                'content' => 'Shipment Sent to Courier'
            ]);
        }
        return redirect()->back();
    }
}
