<?php

namespace Mtc\ShippingManager\Listeners;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Basket\Events\BasketSaved;
use Mtc\ShippingManager\Facades\Shipping;
use Mtc\Shop\Events\NewOrderEvent;

/**
 * Class UpdateOrderShipmentInfo
 *
 * Update order with delivery method information
 *
 * @package Mtc\ShippingManager
 */
class RemoveShippingMethodWhenTypeSwitched
{
    /**
     * Set the delivery name for order when creating it
     *
     * @param NewOrderEvent $event
     */
    public static function handle(BasketSaved $event)
    {
        $basket = $event->basket;
        if ($basket->wasChanged(['shipping_type']) == false) {
            return;
        }

        $enabled_types = Shipping::enabledTypes()->keys();
        $basket->surcharges()
            ->whereIn('surcharge_type', $enabled_types)
            ->delete();

        // Figure out how to resolve this properly in long term
        // this is needed because we don't ajax collection locations like delivery methods
        if ($basket->shipping_type === 'collection') {
            App::make(config('shipping_manager.shipping_types.collection.class'))
                ->methodsForBasket(App::make(BasketRepositoryInterface::class));
        }
    }
}
