# Shipping Manager

This package provides shipping rates for delivery costs, collection locations and courier integration.
This is meant for mtc [shop system](https://bitbucket.org/mtcmedia/shop/) and is triggered within `/checkout` page 
in [basket package](https://bitbucket.org/mtcmedia/packages-basket/).


# Installation 

`mtcmedia/shipping-manager` is part of `mtcmedia/shop` so installation guide is applicable
only when attempting setup without this package. Outcome of this attempt might be
faulty due to potential dependencies on other shop packages.

Steps to install:

Make sure you are installing this on a project that has `composer.mtcassets.com` added as a resource
```bash
composer require mtcmedia/shipping-manager
```
This adds package to vendor.
Next step is to run installation via

```bash
php artisan install:components
```
Installer will set up following steps:
- run migrations from package
- seed base data (e.g. menu entry)
- publish assets (vue components)
- install additional npm dependencies
- compile assets

# Configuration

This package provides two config files:

`config/courier.php` for managing courier integration with our delivery service

`config/shipping_manager.php` for managing shipping related configuration

# Usage

Pacakge provides delivery cost, collect location and courier integration workflows.

Shipping system is built to allow flexibility and different rate types though we rarely require non-default flows.
`Mtc\ShippingManager\Shipping` ( invoked from `DeliveryController`) is the primary entrypoint checkout uses for determining Shipping details.
This then uses the classes specified in the `shipping_manager.php` config for delivery (`TableRateDelivery`)
and collection (`CollectionDelivery`) to retrieve available rates.

Often clients want pre-emptive cost calculation for delivery. This is not a great practice as rate is not known before 
delivery address/rate is known, but system is able to select the cheapest option from table rates using the fallback info of 
basket address (usually generic UK delivery).  

## Shipping rates

Our ecommerce primary delivery rate flow uses a table rate system where rates are determined based of:

* region 
* price or weight range
* additional conditions

Shipping rates are configured in `/admin/shipping-manager/zones` for zones. Zones can be either countries or (UK) postal zones.

Each region allows unlimited amount of rates. These rates will be matched and made available in checkout if the shipping address
of the basket does match the rates zone. Rates also can be restricted via range restriction (price/weight) and modifiers.
Range allows creating different rates for different price/weight gaps (e.g. 5.99 up to 60gbp and then free delivery over 60gbp).

Price modifiers (restrictions) are a mechanism that allows creating custom conditions when rate would apply. Default use case for this
would be free delivery [coupons](https://bitbucket.org/mtcmedia/packages-coupons/). Price modifiers are set up by creating a class that implements
`Mtc\ShippingManager\Contracts\ShippingModifier` interface and then registering modifier in system:
```php
Mtc\ShippingManager\Facades\ShippingModifiers::register($slug_name, new MyModifier());
// e.g ShippingModifiers::register('free-uk-delivery', new FreeUkDelivery());
```

If couriers are enabled each rate will also allow selecting the delivery service associated with that rate.

## Collection Locations

Collect locations is an alternative shipping type that is made available by this package. This is a simple location
selection workflow for implementations of "Collect at store".  

Collection points are enabled by default but will appear as an option on site checkout only when locations are added.
Collection points are added via `/admin/collection-points` section. Each location has a name and address that is used for display.
When selecting location in checkout a simple radio select is displayed. The functionality is robust, but has potential to be expanded to 
more advanced options like geo-locator if required.

## Courier integration

If integration with couriers on system is required this package allows linking up with mtc's own delivery service.
Our delivery service is located [here for production](https://delivery.mtcassets.com/admin) and 
[here for development](https://admin.delivery.mtcdevserver3.com/).

To allow communication with Delivery API a client account will have to be created on these systems.
Staging/development site environments should be tied to development api and production site should
communicate with production service. When creating a client on these services they provide a token that 
is set as `COURIER_SERVICE_API_TOKEN` in .env file.

`COURIER_SERVICE_LIVE` env value (boolean) is used to identify whether site should connect to development or production server.

New shipment is sent via `DispatchShipmentToCourier` job. This is triggered via `ExportShipmentController` 
or `BasicShipmentExportController` by default.

Shipments are sent to Delivery API where they will be processed and labels will be generated for them. Once labels
are generated API will respond to a webhook `/shipping/nofity` with details of the shipment - tracking code and 
shipping label data. Both tracking number and label will be available in order management to allow viewing/printing.

Courier integration _does not_ provide any tracking workflows currently, however this should be possible to implement if 
courier does support.

For documentation on delivery api and supported couriers please visit the [service documentation](https://delivery.mtcassets.com/admin/)


