<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Routing\Router;
use Mtc\ShopDashboardStats\Http\Controllers\DashboardStatsController;

Route::middleware(['web', 'auth'])
    ->prefix('/admin/packages/shop-dashboard-stats/')
    ->name('shop-dashboard-stats.')
    ->group(function(Router $router) {
        $router->get('weekly', [DashboardStatsController::class, 'weekly'])->name('weekly');
        $router->get('monthly', [DashboardStatsController::class, 'monthly'])->name('monthly');
        $router->get('sales', [DashboardStatsController::class, 'sales'])->name('sales');
        $router->get('orders', [DashboardStatsController::class, 'orders'])->name('orders');
        $router->get('analytics', [DashboardStatsController::class, 'analytics'])->name('analytics');
    });
