<?php

namespace Mtc\ShopDashboardStats\Http\Requests;

use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class StatsRequest
 *
 * @package App\Http\Requests
 * @param Carbon $start_date
 * @param Carbon $end_date
 */
class StatsRequest extends FormRequest
{
    /**
     * @var Carbon
     */
    public $start_date;

    /**
     * @var Carbon
     */
    public $end_date;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
        ];
    }

    /**
     *
     */
    protected function prepareForValidation()
    {
        try {
            $this->start_date = Carbon::createFromFormat('d/m/Y', $this->input('start_date'))->startOfDay();
        } catch (\Exception $exception) {
            $this->start_date = Carbon::now()->startOfMonth();
        }

        try {
            $this->end_date = Carbon::createFromFormat('d/m/Y', $this->input('end_date'))->endOfDay();
        } catch (\Exception $exception) {
            $this->end_date = Carbon::now()->endOfDay();
        }
    }
}
