<?php

namespace Mtc\SiteNavigation\Http\Presenters;

use Illuminate\Contracts\Support\Arrayable;
use Mtc\SiteNavigation\SiteNavigation;

/**
 * Class MenuUrlPresenter
 *
 * @package Mtc\SiteNavigation
 */
class MenuUrlPresenter implements Arrayable
{

    /**
     * @var SiteNavigation
     */
    protected $menu;

    /**
     * OrderShipmentBoxUrlPresenter constructor.
     *
     * @param Taxonomy $box
     */
    public function __construct(SiteNavigation $menu)
    {
        $this->menu = $menu;
    }

    /**
     * Accessor
     *
     * @param $key
     * @return mixed
     */
    public function __get($key)
    {
        if(method_exists($this, $key)) {
            return $this->$key();
        }

        return $this->$key;
    }

    /**
     * Add support for conversion to array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'toggle_active' => $this->toggleActive(),
            'update' => $this->update(),
            'destroy' => $this->destroy()
        ];
    }

    /**
     * Update route
     *
     * @return string
     */
    public function update()
    {
        return route('navigation.update', [ $this->menu ]);
    }

    /**
     * Destroy route
     *
     * @return string
     */
    public function destroy()
    {
        return route('navigation.destroy', [ $this->menu ]);
    }

    /**
     * Toggle active state
     *
     * @return string
     */
    public function toggleActive()
    {
        return route('navigation.toggle-active', [ $this->menu ]);
    }
}
