<?php

namespace Mtc\SiteNavigation;

use Illuminate\Support\Facades\File;
use Mtc\Foundation\Contracts\InstallableComponent;
use Mtc\SiteNavigation\Providers\NavigationServiceProvider;
use Mtc\SiteNavigation\Seeds\SiteMenuSeeder;

/**
 * Class NavigationInstaller
 *
 * @package Mtc\SiteNavigation
 */
class NavigationInstaller implements InstallableComponent
{
    /**
     * Define what needs to be published.
     * This should be formatted in following format:
     *
     * @return array
     */
    public function publish(): array
    {
        return [
            [
                '--provider' => NavigationServiceProvider::class,
                '--tag' => 'assets',
            ]
        ];
    }

    /**
     * Provide a classname of seeder that should be called
     * In case of no seed required provide an empty string
     *
     * @return string
     */
    public function seed(): string
    {
        return SiteMenuSeeder::class;
    }

    /**
     * List of npm packages and their version restrictions
     *
     * @return array
     */
    public function npmDependencies(): array
    {
        $package_json = json_decode(File::get(dirname(__DIR__) . '/package.json'), true);
        return $package_json['dependencies'] ?? [];
    }

    /**
     * Whether npm should be run to compile assets after installation has been done
     *
     * @return bool
     */
    public function shouldRunNpm(): bool
    {
        return true;
    }
}
