<?php

namespace Mtc\SiteNavigation\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use Mtc\SiteNavigation\Navigation;
use Mtc\SiteNavigation\Seeds\SiteMenuSeeder;
use Twig_SimpleFunction;

/**
 * Class NavigationServiceProvider
 *
 * @package Mtc\SiteNavigation
 */
class NavigationServiceProvider extends ServiceProvider
{
    /**
     * Register this package
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/site_navigation.php', 'site_navigation');

        $this->app->bind('navigation', Navigation::class);
    }

    /**
     * Start (boot) this service
     */
    public function boot()
    {
        if (config('site_navigation.enabled', false) === false) {
            return;
        }

        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'site_navigation');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');

        if ($this->app->runningInConsole()) {
            $this->publishes([
                dirname(__DIR__, 2) . '/config/site_navigation.php' => config_path('site_navigation.php'),
            ], 'config');

            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            // Publishing the translation files.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/basket'),
            ], 'lang');

            // Registering package commands.
            $this->commands([

            ]);
        }

        \Event::listen('ExtendDatabaseSeeder', SiteMenuSeeder::class);

        app('twig')->addFunction(new Twig_SimpleFunction('show_menu', function ($menu_name, $options = []) {
            return \Mtc\SiteNavigation\Facades\Navigation::show($menu_name, $options);
        }, [
            'is_safe' => ['html']
        ]));

    }
}
