<?php

namespace Mtc\SiteNavigation\Seeds;

use Mtc\Core\Admin\Menu;
use Illuminate\Database\Seeder;

/**
 * Class SiteMenuSeeder
 *
 * @package Mtc\SiteNavigation
 */
class SiteMenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $parent = Menu::query()
            ->where('permission_name', 'content-management')
            ->first();

        Menu::query()
            ->create([
                'sub_id' => $parent->id ?? 0,
                'title' => 'Navigation Menus',
                'path' => '/admin/navigation',
                'activePath' => '/admin/navigation',
                'order' => 0,
            ]);
    }

}
