<?php

// We want to ensure that the test account ID is only set if we're using the test account keys.
// This is for backwards compatibility so we don't set a default account ID on other keys.

$default_account_id = null;
$test_account_id = 'acct_1RLM1KGh1jYgRydC';
$test_private_key = 'rk_test_51L5TnMK4zXXTMRggwxQixjv4XGxjLXUtaWi1jWVYuJHtZqSPsxRgvxeaTRRI1PW4t7HWJMgIAlyf8dStEMfvyrmp00jgESGXbH';
if (env('STRIPE_PRIVATE_KEY', $test_private_key) === $test_private_key) {
    $default_account_id = $test_account_id;
}

return [
    /*
    |--------------------------------------------------------------------------
    | Payment Gateway keys
    |--------------------------------------------------------------------------
    |
    | Please set site specific keys in .env file
    | These keys are bound to mtc test account, through Stripe Connect.
    | Production keys should never be part of tracked repo
    |
    */
    'public_key' => env('STRIPE_PUBLIC_KEY', 'pk_test_51RLM1KGh1jYgRydChUk1igmHdyAMAHZICSQMZXAcVVTSZ2uEtLHIvw3u5eZOH6PWP3elSp2byqztcr777a3WrDf800lTjHz0tT'),
    'private_key' => env('STRIPE_PRIVATE_KEY', $test_private_key),
    'account_id' => env('STRIPE_ACCOUNT_ID', $default_account_id),

    /*
    |--------------------------------------------------------------------------
    | Applicable check
    |--------------------------------------------------------------------------
    |
    | Restrict payment gateway to being available only on certain situations
    | Default class allows always, however this can be set to restrict based
    | on invoice type/contents or member type
    |
    */
    'applicable_check_class' => \Mtc\Stripe\StripeApplicableCheck::class,
    'external_payments_applicable_check_class' => \Mtc\Stripe\StripeExternalPaymentsApplicableCheck::class,
    'payment_gateway_class' => \Mtc\Stripe\Stripe::class,

    /*
    |--------------------------------------------------------------------------
    | Minimal transaction amount
    |--------------------------------------------------------------------------
    |
    | Stripe will not be available if the invoice amount is below given value
    | Stripe by default does not support payments below 0.30 EUR
    |
    */
    'minimal_transaction_amount' => 0.30,


    /*
    |--------------------------------------------------------------------------
    | Advanced payment options
    |--------------------------------------------------------------------------
    |
    | Enable additional payment gateways like Apple Pay, Google Pay and Microsoft Pay
    | through Stripe Payment request API
    | This is an up-sell / additional cost item and should not be enabled for stock integration
    |
    */
    'additional_payment_gateways' => false,
    'basket_fill_factory' => \Mtc\Stripe\StripePaymentRequestBasketPreFillFactory::class,

    /*
    |--------------------------------------------------------------------------
    | Confirmation status
    |--------------------------------------------------------------------------
    |
    | Status that will be set on order when it is paid using this payment gateway.
    | Allows switching to "Awaiting Payment" or other statuses based on necessity.
    |
    */

    'confirmation_status' => 1,

    /*
    |--------------------------------------------------------------------------
    | Card storage
    |--------------------------------------------------------------------------
    |
    | Enabling card storage will allow users to save their cards for reusing
    | on next purchases. Functionality available for logged in members only.
    |
    */

    'card_storage' => false,
];
