<?php

namespace Mtc\Stripe\Listeners;

use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Stripe\StripePaymentRequest;

/**
 * Class AddStripeExternalScripts
 *
 * Injects stripe payment script to payment page
 *
 * @package Mtc\Stripe
 */
class AddStripePaymentRequestButton
{

    /**
     * Add the payment request button to basket
     *
     * @param BasketRepositoryInterface $basket
     */
    public static function handle(BasketRepositoryInterface $basket)
    {
        if (App::make(config('stripe.external_payments_applicable_check_class'))->handle($basket)) {
            $basket->setExternalGateway('stripe-external', App::make(StripePaymentRequest::class)->getPaymentForm($basket));
        }
        return null;
    }
}
