<?php

namespace Mtc\Stripe;

use Illuminate\Http\Request;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Stripe\Contracts\StripePaymentRequestBasketFillInterface;

/**
 * Class PayPalBasketFillFactory
 *
 * @package Mtc\Stripe
 */
class StripePaymentRequestBasketPreFillFactory implements StripePaymentRequestBasketFillInterface
{
    /**
     * Update basket from paypal details
     *
     * @param BasketRepositoryInterface $basket
     * @return BasketRepositoryInterface
     */
    public function fill(Request $request, BasketRepositoryInterface $basket)
    {
        $this->setShippingAddress($request, $basket);
        $this->setBillingAddress($request, $basket);
        $this->setDetails($request, $basket);
        return $basket;
    }

    /**
     * Set up shipping address
     *
     * @param Request $request
     * @param BasketRepositoryInterface $basket
     */
    public function setShippingAddress(Request $request, BasketRepositoryInterface $basket)
    {
        $name = explode(' ', $request->input('shippingAddress.recipient'));
        $basket->setAddress('shipping', [
            'last_name' => array_pop($name),
            'first_name' => implode(' ', $name),
            'address1' => $request->input('shippingAddress.addressLine.0', ''),
            'address2' => $request->input('shippingAddress.addressLine.1', ''),
            'city' => $request->input('shippingAddress.city'),
            'state' => $request->input('shippingAddress.region'),
            'country' => $request->input('shippingAddress.country'),
            'postcode' => $request->input('shippingAddress.postalCode')
        ]);
    }

    /**
     * Set up billing address
     *
     * @param Request $request
     * @param BasketRepositoryInterface $basket
     */
    public function setBillingAddress(Request $request, BasketRepositoryInterface $basket)
    {

        $name = explode(' ', $request->input('paymentMethod.billing_details.name'));
        $basket->setAddress('billing', [
            'last_name' => array_pop($name),
            'first_name' => implode(' ', $name),
            'address1' => $request->input('paymentMethod.billing_details.address.line1', ''),
            'address2' => $request->input('paymentMethod.billing_details.address.line2', ''),
            'city' => $request->input('paymentMethod.billing_details.address.city'),
            'state' => $request->input('paymentMethod.billing_details.address.state'),
            'country' => $request->input('paymentMethod.billing_details.address.country'),
            'postcode' => $request->input('paymentMethod.billing_details.address.postal_code')
        ]);
    }

    /**
     * Set basket details values
     *
     * @param Request $request
     * @param BasketRepositoryInterface $basket
     */
    public function setDetails(Request $request, BasketRepositoryInterface $basket)
    {
        $basket->setDetails([
            'email' => $request->input('payerEmail'),
            'contact_number' => $request->input('payerPhone'),
            'newsletter_signup' => 0,
        ]);
    }
}
