<?php

namespace Mtc\Stripe\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Mtc\Checkout\Events\AddPaymentGatewayScripts;
use Mtc\Stripe\Console\Commands\InstallStripe;
use Mtc\Stripe\Listeners\AddStripeExternalScripts;
use Mtc\Stripe\Stripe;

/**
 * Class StripeServiceProvider
 *
 * @package Mtc\Stripe\Providers
 */
class StripeServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'stripe');
        $this->app['payment']->extend('stripe', function($app) {
            return new Stripe();
        });

        if (!$this->app->runningInConsole()) {
            Event::listen(AddPaymentGatewayScripts::class, AddStripeExternalScripts::class);
        } else {
            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            $this->commands([
                InstallStripe::class,
            ]);
        }
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/stripe.php', 'stripe');

    }
}
