<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Payment Gateway keys
    |--------------------------------------------------------------------------
    |
    | Please set site specific keys in .env file
    | These keys are bound to mtc test account.
    | Production keys should never be part of tracked repo
    |
    */
    'public_key' => env('STRIPE_PUBLIC_KEY', 'pk_test_EGGB3Mib0kBkC3cLboLhLnPr'),
    'private_key' => env('STRIPE_PRIVATE_KEY', 'sk_test_AqdCtqtij5PdoIcvt335LZbf'),

    /*
    |--------------------------------------------------------------------------
    | Applicable check
    |--------------------------------------------------------------------------
    |
    | Restrict payment gateway to being available only on certain situations
    | Default class allows always, however this can be set to restrict based
    | on invoice type/contents or member type
    |
    */
    'applicable_check_class' => \Mtc\Stripe\StripeApplicableCheck::class,

    /*
    |--------------------------------------------------------------------------
    | Advanced payment options
    |--------------------------------------------------------------------------
    |
    | Enable additional payment gateways like Apple Pay, Google Pay and Microsoft Pay
    | through Stripe Payment request API
    | This is an up-sell / additional cost item and should not be enabled for stock integration
    |
    */
    'additional_payment_gateways' => false,

    /*
    |--------------------------------------------------------------------------
    | Confirmation status
    |--------------------------------------------------------------------------
    |
    | Status that will be set on order when it is paid using this payment gateway.
    | Allows switching to "Awaiting Payment" or other statuses based on necessity.
    |
    */

    'confirmation_status' => 1,

    /*
    |--------------------------------------------------------------------------
    | Card storage
    |--------------------------------------------------------------------------
    |
    | Enabling card storage will allow users to save their cards for reusing
    | on next purchases. Functionality available for logged in members only.
    |
    */

    'card_storage' => false,
];
