<?php

namespace Mtc\Stripe\Config;

class StripeConfig
{
    public function privateKey(): string
    {
        return config('stripe.private_key');
    }

    public function publicKey(): string
    {
        return config('stripe.public_key');
    }

    public function applicableCheckClass(): string
    {
        return config('stripe.applicable_check_class');
    }

    public function externalPaymentsApplicableCheckClass(): string
    {
        return config('stripe.external_payments_applicable_check_class');
    }

    public function paymentGatewayClass(): string
    {
        return config('stripe.payment_gateway_class');
    }

    public function minimalTransactionAmount(): string
    {
        return config('stripe.minimal_transaction_amount');
    }

    public function additionalPaymentGateways(): bool
    {
        return config('stripe.additional_payment_gateways');
    }

    public function basketFillFactory(): string
    {
        return config('stripe.basket_fill_factory');
    }

    public function confirmationStatus(): string
    {
        return config('stripe.confirmation_status', null);
    }

    public function cardStorage(): bool
    {
        return config('stripe.card_storage', false);
    }
}
