<?php

return [

    'taxonomy_model' => \Mtc\Taxonomies\Models\Taxonomy::class,
    'repository_class' => \Mtc\Taxonomies\TaxonomyRepository::class,

    'edit_taxonomy_sections' => [
        'taxonomies::partials.details',
        'taxonomies::partials.custom_fields',
    ],

    'field_types' => [
        'taxonomy' => \Mtc\Taxonomies\Fields\TaxonomyField::class
    ],

    'events' => [
        \Mtc\Input\Events\RegisterFieldTypes::class => [
            \Mtc\Taxonomies\Listeners\AddTaxonomyCustomFieldType::class,
        ]
    ],

    'controllers' => [
        'export' => \Mtc\Taxonomies\Http\Controllers\ExportTaxonomyController::class,
        'import' => \Mtc\Taxonomies\Http\Controllers\ImportTaxonomyController::class,
    ],

    'export_class' => \Mtc\Taxonomies\Exports\TaxonomyExport::class,

    'export_formats' => [
        [
            'id' => 'csv',
            'name' => 'CSV File'
        ],
        [
            'id' => 'xlsx',
            'name' => 'Excel Spreadsheet',
        ],
    ],
];
