<div class="card card-body">
    <form action="{{ route('taxonomies.import.run', $taxonomy->slug) }}" method="post">

        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Column</th>
                    <th>Matched Field</th>
                    <th>Example values</th>
                </tr>
            </thead>
            <tbody>
            @foreach($data[0] as $column => $value)
                <tr>
                    <td>{{ $column }}</td>
                    <td>
                        <select name="import_map[{{ $column }}]" class="form-control">
                            <option value="">Don't map</option>
                            @foreach ($import_columns as $option)
                                <option value="{{ $option['id'] }}" {{ $column === $option['id'] ? 'selected' : '' }}>
                                    {{ $option['name'] }}
                                </option>
                            @endforeach
                        </select>
                    </td>
                    <td>{{ $data->pluck($column)->unique()->implode(', ') }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>

        <x-form::checkbox
            id="set_active"
            name="set_active"
            wrapper-class="col-lg-4"
            field-value="1"
            value="0">
            Set imported entries as Active
        </x-form::checkbox>

        <p>Import file consists of {{ $total_records }} records to process</p>
        <button type="submit" class="btn btn-primary">
            Run Import
        </button>
        {{ method_field('PUT') }}
        {{ csrf_field() }}
    </form>
</div> <!-- end col -->
