@extends('admin::layouts.admin')

@section('title', $taxonomy->name . ' | Taxonomies')

@section('content')

    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title">{{ Illuminate\Support\Str::plural($taxonomy->name) }}</h4>
                </div>
            </div>
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-2">
                            <div class="col-lg-12">
                                <div class="text-lg-right">
                                    <a href="{{ route('taxonomies.import', $taxonomy->slug) }}" class="btn btn-light">
                                        <i class="far fa-cloud-upload-alt"></i>
                                        Import
                                    </a>
                                    <a href="{{ route('taxonomies.export', $taxonomy->slug) }}" class="btn btn-light">
                                        <i class="far fa-cloud-download-alt"></i>
                                        Export
                                    </a>
                                    <a href="{{ route('taxonomies.edit', $taxonomy->id) }}" class="btn btn-light">
                                        Manage
                                    </a>
                                </div>
                            </div><!-- end col-->
                        </div>
                        <taxonomies slug="{{ $taxonomy->slug }}"></taxonomies>
                    </div> <!-- end card-body-->
                </div> <!-- end card-->
            </div> <!-- end col -->
        </div>
    </div>
@endsection
