<?php

namespace Mtc\Taxonomies\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\Taxonomies\Imports\TaxonomyImport;

class RunTaxonomyImport implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(
        protected array $import_map,
        protected int $active,
        protected string $file_name,
        protected string $root_taxonomy_id
    ) {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        (new TaxonomyImport())
            ->setMap($this->import_map)
            ->setActive($this->active)
            ->setParentModelId($this->root_taxonomy_id)
            ->import($this->file_name);
    }
}
