<?php

namespace Mtc\Taxonomies\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class RootLevelTaxonomyIsScope implements Scope
{
    public function __construct(protected string $taxonomy_slug)
    {
    }

    /**
     * @param Builder $builder
     * @param Model $model
     */
    public function apply(Builder $builder, Model $model)
    {
        return $builder
            ->whereHas('ancestors', function ($query) {
                $query->where('slug', $this->taxonomy_slug);
            });
    }
}
