<?php

namespace Mtc\Taxonomies\Http\Presenters;

use Illuminate\Contracts\Support\Arrayable;
use Mtc\Taxonomies\Taxonomy;

/**
 * Class OrderShipmentBoxUrlPresenter
 *
 * @package Mtc\Orders
 */
class TaxonomyUrlPresenter implements Arrayable
{
    /**
     * @var Taxonomy
     */
    protected $taxonomy;

    /**
     * OrderShipmentBoxUrlPresenter constructor.
     *
     * @param Taxonomy $box
     */
    public function __construct(Taxonomy $taxonomy)
    {
        $this->taxonomy = $taxonomy;
    }

    /**
     * Accessor
     *
     * @param $key
     * @return mixed
     */
    public function __get($key)
    {
        if (method_exists($this, $key)) {
            return $this->$key();
        }

        return $this->$key;
    }

    /**
     * Add support for conversion to array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'toggle_active' => $this->toggleActive(),
            'reorder' => $this->reorder(),
            'update' => $this->update(),
            'destroy' => $this->destroy()
        ];
    }

    /**
     * Update route
     *
     * @return string
     */
    public function update()
    {
        return route('taxonomies.update', [$this->taxonomy->id]);
    }

    /**
     * Destroy route
     *
     * @return string
     */
    public function destroy()
    {
        return route('taxonomies.destroy', [$this->taxonomy->id]);
    }

    /**
     * Toggle active state
     *
     * @return string
     */
    public function toggleActive()
    {
        return route('taxonomies.toggle-active', [$this->taxonomy->id]);
    }

    /**
     * Reorder routes
     *
     * @return string
     */
    public function reorder()
    {
        return route('taxonomies.reorder');
    }
}
