<?php

namespace Mtc\Taxonomies\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class TaxonomyList
 *
 * @package Mtc\Taxonomies
 */
class TaxonomyList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource->children
            ->map(function ($child) {
                $child->is_open = false;
                $child->edit = false;
                return $child;
            });
        return parent::toArray($request);
    }
}
