<?php

namespace Mtc\VehicleLookup\Drivers;

use Mtc\VehicleLookup\Contracts\VehicleLookupDriver;
use Mtc\VehicleLookup\VehicleLookupResponse;
use Mtc\VehicleValuation\AutoTrader as ValuationAutoTrader;

class AutoTrader extends ValuationAutoTrader implements VehicleLookupDriver
{
    public function lookup(string $registration_number, int $mileage): VehicleLookupResponse
    {
        return $this->parseResponse($registration_number, $this->getVehicleData($registration_number));
    }

    private function parseResponse(string $registration_number, array $vehicle): VehicleLookupResponse
    {
        return new VehicleLookupResponse(
            $registration_number,
            make: $vehicle['make'] ?? null,
            model: $vehicle['model'] ?? null,
            manufacture_year: $vehicle['manufacture_year'] ?? null,
            colour: $vehicle['colour'] ?? null,
            body_type: $vehicle['body_type'] ?? null,
            fuel_type: $vehicle['fuel_type'] ?? null,
            transmission: $vehicle['transmission'] ?? null,
        );
    }
}
