<?php

namespace Mtc\VehicleLookup\Drivers;

use Mtc\VehicleLookup\Contracts\VehicleLookupDriver;
use Mtc\VehicleLookup\VehicleLookupResponse;
use Mtc\VehicleValuation\Exceptions\ValuationRequestFailed;

class BeepBeep extends \Mtc\VehicleValuation\BeepBeep implements VehicleLookupDriver
{
    public function lookup(string $registration_number, int $mileage): VehicleLookupResponse
    {
        try {
            return $this->parseResponse($registration_number, $mileage, $this->getVehicleData($registration_number));
        } catch (ValuationRequestFailed $e) {
            return new VehicleLookupResponse($registration_number, $mileage);
        }
    }

    private function parseResponse(string $registration_number, $mileage, array $vehicle): VehicleLookupResponse
    {
        return new VehicleLookupResponse(
            $registration_number,
            $mileage,
            make: $vehicle['vehicleSummary']['make']
                ?? $vehicle['ukHistory']['technical']['make'] ?? '',
            model: $vehicle['vehicleSummary']['model'] ?? $vehicle['ukHistory']['technical']['model'] ?? '',
            derivative: $vehicle['vehicleSummary']['modelDescription'] ?? '',
            colour: $vehicle['vehicleSummary']['colour'] ?? $vehicle['ukHistory']['technical']['colour'] ?? '',
            body_type: $vehicle['vehicleSummary']['bodyType']
                ?? $vehicle['ukHistory']['technical']['bodyType'] ?? '',
            fuel_type: $vehicle['vehicleSummary']['fuelType'] ?? $vehicle['ukHistory']['technical']['fuel'] ?? '',
            transmission: $vehicle['vehicleSummary']['transmission']
                ?? $vehicle['ukHistory']['technical']['transmission'] ?? '',
        );
    }
}
