<?php

namespace Mtc\VehicleLookup\Drivers;

use Illuminate\Support\Facades\Http;
use Mtc\VehicleLookup\Contracts\VehicleLookupDriver;
use Mtc\VehicleLookup\VehicleLookupResponse;

class UKMOT implements VehicleLookupDriver
{
    public function lookup(string $registration_number, int $mileage): VehicleLookupResponse
    {
        return $this->parseResponse($registration_number, $this->getVehicleData($registration_number));
    }

    private function getVehicleData(string $registration_number): array
    {
        return Http::withHeaders([
            'Accept' => 'application/json',
            'x-api-key' => $this->apiKey(),
        ])
            ->get('https://beta.check-mot.service.gov.uk/trade/vehicles/mot-tests?registration=' . $registration_number)
            ->json();
    }

    private function parseResponse(string $registration_number, array $vehicle_data): VehicleLookupResponse
    {
        dd($vehicle_data);
        return new VehicleLookupResponse(
            $registration_number,
        );
    }

    private function apiKey(): string
    {
        return config('services.uk-mot.api_key');
    }
}
