<?php

namespace Mtc\VehicleLookup\Drivers;

use App\Modules\Lookup\Contracts\VehicleLookupData;
use Illuminate\Support\Facades\Http;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\VehicleLookup\Contracts\VehicleLookupDriver;
use Mtc\VehicleLookup\VehicleLookupResponse;

class NullDriver implements VehicleLookupDriver
{
    public function lookup(string $registration_number, int $mileage): VehicleLookupResponse
    {
        return new VehicleLookupResponse($registration_number);
    }

    public function findDerivatives(VehicleMake $make, VehicleModel $model): array
    {
        return [];
    }

    public function findVariants(VehicleMake $make, VehicleModel $model, string $derivative = ''): array
    {
        return [];
    }

    public function getTechnicalData(string $variant): VehicleLookupData
    {
        return new VehicleLookupData();
    }
}
