<?php

namespace Mtc\VehicleLookup\Drivers;

use Mtc\VehicleLookup\Contracts\VehicleLookupDriver;
use Mtc\VehicleLookup\VehicleLookupResponse;
use Mtc\VehicleValuation\AutoTrader as ValuationAutoTrader;

class AutoTrader extends ValuationAutoTrader implements VehicleLookupDriver
{
    public function lookup(string $registration_number, int $mileage): VehicleLookupResponse
    {
        return $this->parseResponse($registration_number, $mileage, $this->getVehicleData($registration_number));
    }

    private function parseResponse(string $registration_number, $mileage, array $vehicle): VehicleLookupResponse
    {
        return new VehicleLookupResponse(
            $registration_number,
            $mileage,
            make: $vehicle['make'] ?? null,
            model: $vehicle['model'] ?? null,
            derivative: $vehicle['derivative'] ?? null,
            colour: $vehicle['colour'] ?? null,
            body_type: $vehicle['bodyType'] ?? null,
            fuel_type: $vehicle['fuelType'] ?? null,
            transmission: $vehicle['transmissionType'] ?? null,
        );
    }
}
