<?php

namespace Mtc\VehicleLookup\Drivers;

use Mtc\VehicleLookup\Contracts\VehicleLookupDriver;
use Mtc\VehicleLookup\VehicleLookupResponse;
use Mtc\VehicleValuation\BCA as BCAValuation;

class BCA extends BCAValuation implements VehicleLookupDriver
{

    public function lookup(string $registration_number, int $mileage): VehicleLookupResponse
    {
        return $this->parseResponse($registration_number, $mileage, $this->getVehicleData($registration_number));
    }

    private function parseResponse(string $registration_number, $mileage, array $vehicle): VehicleLookupResponse
    {
        $vehicleSpecification = null;
        if(!empty($vehicle['vehicleSpecifications'][0])){
            $vehicleSpecification = $vehicle['vehicleSpecifications'][0];
        }

        return new VehicleLookupResponse(
            $registration_number,
            $mileage,
            make: $vehicleSpecification['make'] ?? null,
            model: $vehicleSpecification['model'] ?? null,
            derivative: $vehicleSpecification['derivative'] ?? null,
            manufacture_year: $vehicleSpecification['modelYear'] ?? null,
            colour: $vehicleSpecification['colour'] ?? null,
            body_type: $vehicleSpecification['bodyType'] ?? null,
            fuel_type: $vehicleSpecification['fuelType'] ?? null,
            transmission: $vehicleSpecification['transmissionType'] ?? null,
        );
    }
}
