<?php

namespace Mtc\VehicleLookup;

use App\Facades\Settings;
use Illuminate\Support\Facades\App;
use Mtc\VehicleLookup\Contracts\VehicleLookupDriver;
use Mtc\VehicleLookup\Drivers\AutoTrader;
use Mtc\VehicleLookup\Drivers\BeepBeep;
use Mtc\VehicleLookup\Drivers\CAP;
use Mtc\VehicleLookup\Drivers\BCA;
use Mtc\VehicleLookup\Drivers\NullDriver;
use Mtc\VehicleLookup\Drivers\UKMOT;

class VehicleLookupService
{
    private VehicleLookupDriver $active_driver;

    public function findByVRM(string $registration_number, int $mileage): VehicleLookupResponse
    {
        return $this->getDriver()->lookup($registration_number, $mileage);
    }

    private function getDriver(): VehicleLookupDriver
    {
        if (!isset($this->active_driver)) {
            $this->loadDriver();
        }

        return $this->active_driver;
    }

    private function loadDriver(): void
    {
        $this->active_driver = match ($this->findActiveDriver()) {
            'auto-trader' => new AutoTrader(App::make(config('lookup.drivers')['auto-trader']['config'])),
            'bca' => new BCA(App::make(config('lookup.drivers')['bca']['config'])),
            'cap' => new CAP(App::make(config('lookup.drivers')['cap']['config'])),
            'beep-beep' => new BeepBeep(App::make(config('lookup.drivers')['beep-beep']['config'])),
            'uk-mot' => new UKMOT(),
            default => new NullDriver(),
        };
    }

    private function findActiveDriver(): ?string
    {
        return collect([
            'auto-trader' => 'lookup-auto-trader-enabled',
            'cap' => 'lookup-cap-enabled',
            'bca' => 'lookup-bca-enabled',
            'uk-mot' => 'lookup-uk-mot',
            'beep-beep' => 'lookup-beepbeep-enabled',
        ])->filter(fn($setting) => Settings::get($setting))
            ->keys()
            ->first();
    }
}
