<?php

namespace Mtc\VehicleLookup\Drivers;

use App\Modules\Lookup\Contracts\VehicleLookupData;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\VehicleLookup\Contracts\VehicleLookupDriver;
use Mtc\VehicleLookup\VehicleLookupResponse;
use Mtc\VehicleValuation\Exceptions\ValuationRequestFailed;

class BeepBeep extends \Mtc\VehicleValuation\BeepBeep implements VehicleLookupDriver
{
    public function lookup(string $registration_number, int $mileage): VehicleLookupResponse
    {
        try {
            return $this->parseResponse($registration_number, $mileage, $this->getVehicleData($registration_number));
        } catch (ValuationRequestFailed $e) {
            return new VehicleLookupResponse($registration_number, $mileage);
        }
    }

    private function parseResponse(string $registration_number, $mileage, array $vehicle): VehicleLookupResponse
    {
        return new VehicleLookupResponse(
            $registration_number,
            $mileage,
            make: $vehicle['vehicleSummary']['make']
                ?? $vehicle['ukHistory']['technical']['make'] ?? '',
            model: $vehicle['vehicleSummary']['model'] ?? $vehicle['ukHistory']['technical']['model'] ?? '',
            derivative: $vehicle['vehicleSummary']['modelDescription'] ?? '',
            colour: $vehicle['vehicleSummary']['colour'] ?? $vehicle['ukHistory']['technical']['colour'] ?? '',
            body_type: $vehicle['vehicleSummary']['bodyType']
                ?? $vehicle['ukHistory']['technical']['bodyType'] ?? '',
            fuel_type: $vehicle['vehicleSummary']['fuelType'] ?? $vehicle['ukHistory']['technical']['fuel'] ?? '',
            transmission: $vehicle['vehicleSummary']['transmission']
                ?? $vehicle['ukHistory']['technical']['transmission'] ?? '',
        );
    }

    public function findDerivatives(VehicleMake $make, VehicleModel $model): array
    {
        return [];
    }

    public function findVariants(VehicleMake $make, VehicleModel $model, string $derivative = ''): array
    {
        return [];
    }

    public function getTechnicalData(string $variant): VehicleLookupData
    {
        return new VehicleLookupData();
    }
}
