<?php

namespace Mtc\VehicleLookup;

use Illuminate\Support\Collection;

class VehicleLookupResponse
{
    public function __construct(
        public readonly string $registration_number,
        public readonly ?string $mileage = null,
        public readonly ?string $make = null,
        public readonly ?string $model = null,
        public readonly ?string $derivative = null,
        public readonly ?int $manufacture_year = null,
        public readonly ?string $colour = null,
        public readonly ?string $body_type = null,
        public readonly ?string $fuel_type = null,
        public readonly ?string $transmission = null,
        public readonly ?string $model_year = null,
        public readonly ?string $registration_date = null,
        public readonly ?string $mpg = null,
        public readonly ?string $co2 = null,
        public readonly ?string $engine_capacity_cc = null,
        public readonly ?string $body_style = null,
        public readonly ?string $drivetrain = null,
        public readonly ?string $vehicle_type = 'Car',
        public readonly ?string $vin = null,
        public readonly ?int $doors = null,
        public readonly ?int $seats = null,
        public readonly ?int $previous_owner_count = null,
        public readonly ?Collection $features = null,
        public readonly ?Collection $standard_equipment = null,
        public readonly ?Collection $technical_data = null,
        public readonly ?int $battery_capacity_kwh = null,
        public readonly ?int $battery_charge_time = null,
        public readonly ?int $battery_quick_charge_time = null,
        public readonly ?int $battery_quick_charge_start_level = null,
        public readonly ?int $battery_quick_charge_level = null,
        public readonly ?string $plug_type = null,
        public readonly ?string $rapid_charge_plug_type = null,
        public readonly ?string $battery_slow_charge_description = null,
        public readonly ?string $battery_quick_charge_description = null,
    ) {
        //
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}
