
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Your Message Subject or Title</title>
    <style type="text/css">

        /***********
        Originally based on The MailChimp Reset from Fabio Carneiro, MailChimp User Experience Design
        More info and templates on Github: https://github.com/mailchimp/Email-Blueprints
        http://www.mailchimp.com &amp; http://www.fabio-carneiro.com

        INLINE: No.
        ***********/
        /* Client-specific Styles */
        #outlook a {padding:0;} /* Force Outlook to provide a "view in browser" menu link. */
        body{width:100% !important; height:100% !important; -webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; margin:0; padding:0;}
        /* Prevent Webkit and Windows Mobile platforms from changing default font sizes, while not breaking desktop design. */
        .ExternalClass {width:100%;} /* Force Hotmail to display emails at full width */
        .ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div {line-height: 100%;} /* Force Hotmail to display normal line spacing. */
        #backgroundTable {margin:0; padding:0; width:100% !important; height:100% !important; line-height: 100% !important;}
        /* End reset */

        /* Some sensible defaults for images
        1. "-ms-interpolation-mode: bicubic" works to help ie properly resize images in IE. (if you are resizing them using the width and height attributes)
        2. "border:none" removes border when linking images.
        3. Updated the common Gmail/Hotmail image display fix: Gmail and Hotmail unwantedly adds in an extra space below images when using non IE browsers. You may not always want all of your images to be block elements. Apply the "imageFix" class to any image you need to fix.

        Bring inline: Yes.
        */
        img {outline:none; text-decoration:none; -ms-interpolation-mode: bicubic;}
        a img {border:none;}
        .imageFix {display:block;}

        /** Yahoo paragraph fix: removes the proper spacing or the paragraph (p) tag. To correct we set the top/bottom margin to 1em in the head of the document. Simple fix with little effect on other styling. NOTE: It is also common to use two breaks instead of the paragraph tag but I think this way is cleaner and more semantic. NOTE: This example recommends 1em. More info on setting web defaults: http://www.w3.org/TR/CSS21/sample.html or http://meiert.com/en/blog/20070922/user-agent-style-sheets/

        Bring inline: Yes.
        **/
        p {margin: 0 0 1em 0;}

        /** Hotmail header color reset: Hotmail replaces your header color styles with a green color on H2, H3, H4, H5, and H6 tags. In this example, the color is reset to black for a non-linked header, blue for a linked header, red for an active header (limited support), and purple for a visited header (limited support).  Replace with your choice of color. The !important is really what is overriding Hotmail's styling. Hotmail also sets the H1 and H2 tags to the same size.

        Bring inline: Yes.
        **/
        h1, h2, h3, h4, h5, h6 {color: #324E60 !important;}

        h1 a, h2 a, h3 a, h4 a, h5 a, h6 a {color: #324E60 !important;}

        h1 a:active, h2 a:active,  h3 a:active, h4 a:active, h5 a:active, h6 a:active {
            color: #324E60 !important; /* Preferably not the same color as the normal header link color.  There is limited support for psuedo classes in email clients, this was added just for good measure. */
        }

        h1 a:visited, h2 a:visited,  h3 a:visited, h4 a:visited, h5 a:visited, h6 a:visited {
            color: #324E60 !important; /* Preferably not the same color as the normal header link color. There is limited support for psuedo classes in email clients, this was added just for good measure. */
        }

        /** Outlook 07, 10 Padding issue: These "newer" versions of Outlook add some padding around table cells potentially throwing off your perfectly pixeled table.  The issue can cause added space and also throw off borders completely.  Use this fix in your header or inline to safely fix your table woes.

        More info: http://www.ianhoar.com/2008/04/29/outlook-2007-borders-and-1px-padding-on-table-cells/
        http://www.campaignmonitor.com/blog/post/3392/1px-borders-padding-on-table-cells-in-outlook-07/

        H/T @edmelly

        Bring inline: No.
        **/
        table td {border-collapse: collapse;}

        /** Remove spacing around Outlook 07, 10 tables

        More info : http://www.campaignmonitor.com/blog/post/3694/removing-spacing-from-around-tables-in-outlook-2007-and-2010/

        Bring inline: Yes
        **/
        table { border-collapse:collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; }

        /* Styling your links has become much simpler with the new Yahoo.  In fact, it falls in line with the main credo of styling in email, bring your styles inline.  Your link colors will be uniform across clients when brought inline.

        Bring inline: Yes. */
        a {color: #324E60;}

        /* Or to go the gold star route...
        a:link { color: orange; }
        a:visited { color: blue; }
        a:hover { color: green; }
        */

        /***************************************************
        ****************************************************
        MOBILE TARGETING

        Use @media queries with care.  You should not bring these styles inline -- so it's recommended to apply them AFTER you bring the other stlying inline.

        Note: test carefully with Yahoo.
        Note 2: Don't bring anything below this line inline.
        ****************************************************
        ***************************************************/

        /* NOTE: To properly use @media queries and play nice with yahoo mail, use attribute selectors in place of class, id declarations.
        table[class=classname]
        Read more: http://www.campaignmonitor.com/blog/post/3457/media-query-issues-in-yahoo-mail-mobile-email/
        */
        @media only screen and (max-device-width: 700px) {

            /* A nice and clean way to target phone numbers you want clickable and avoid a mobile phone from linking other numbers that look like, but are not phone numbers.  Use these two blocks of code to "unstyle" any numbers that may be linked.  The second block gives you a class to apply with a span tag to the numbers you would like linked and styled.

            Inspired by Campaign Monitor's article on using phone numbers in email: http://www.campaignmonitor.com/blog/post/3571/using-phone-numbers-in-html-email/.

            Step 1 (Step 2: line 224)
            */
            a[href^="tel"], a[href^="sms"] {
                text-decoration: none;
                color: #324E60; /* or whatever your want */
                pointer-events: none;
                cursor: default;
            }

            .mobileLink a[href^="tel"], .mobileLink a[href^="sms"] {
                text-decoration: default;
                color: #324E60 !important; /* or whatever your want */
                pointer-events: auto;
                cursor: default;
            }
        }

        /* More Specific Targeting */

        @media only screen and (min-device-width: 768px) and (max-device-width: 1024px) {
            /* You guessed it, ipad (tablets, smaller screens, etc) */

            /* Step 1a: Repeating for the iPad */
            a[href^="tel"], a[href^="sms"] {
                text-decoration: none;
                color: #324E60; /* or whatever your want */
                pointer-events: none;
                cursor: default;
            }

            .mobileLink a[href^="tel"], .mobileLink a[href^="sms"] {
                text-decoration: default;
                color: #324E60 !important;
                pointer-events: auto;
                cursor: default;
            }
        }
    </style>

    <!-- ***********************************************
    ****************************************************
    END MOBILE TARGETING
    ****************************************************
    ************************************************ -->

    <!--[if gte mso 9]>
    <style>
        /* Target Outlook 2007 and 2010 */
    </style>
    <![endif]-->
</head>
<body>
<!-- Wrapper/Container Table: Use a wrapper table to control the width and the background color consistently of your email. Use this approach instead of setting attributes on the body tag. -->
<table cellpadding="0" cellspacing="0" border="0" id="backgroundTable" bgcolor="#F2F5F7" style="background-color:#F2F5F7;">
    <tr>
        <td valign="top" height="80"></td>
    </tr>
    <tr>
        <td>
            <!-- INNER WRAPPER START -->
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="940" bgcolor="#FFFFFF" style="background-color:#FFFFFF;border-radius:20px;">
                <!-- HEADER START -->
                <tr>
                    <td valign="top" height="40"></td>
                </tr>
                <tr>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <tr>
                                <td valign="top" width="50"></td>
                                <td valign="top" align="left">
                                    <a href="/" target="_blank" title="Prestige Cars Kent" style="text-decoration: none;">
                                        <img class="imageFix" src="/images/logo.png" alt="Logo" title="Prestige Cars Kent" width="127" height="75" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                    </a>
                                </td>
                                <td align="right">
                                    <table cellpadding="0" cellspacing="0" border="0" align="right" width="100%">
                                        <tr>
                                            <td valign="top" align="right">
                                                <p style="color:#324E60; margin:0; font-size:18px; font-weight:700; letter-spacing:-0.36px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">Speak to the team</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top" align="right" height="8"></td>
                                        </tr>
                                        <tr>
                                            <td valign="top" align="right">
                                                <table cellpadding="0" cellspacing="0" border="0" align="right">
                                                    <tr>
                                                        <td align="right">
                                                            <img class="imageFix" src="/images/icons/phone.png" alt="Logo" title="Phone Us" width="24" height="24" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                                        </td>
                                                        <td align="right" width="8"></td>
                                                        <td align="right">
                                                            <span>
                                                                <a href="tel:08001234456" target="_blank" style="color:#324E60; margin:0; font-size:30px; font-weight:700; letter-spacing:-0.6px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; text-decoration: none;">0800 1234 456</a>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top" align="right" height="3"></td>
                                        </tr>
                                        <tr>
                                            <td valign="top" align="right">
                                                <p style="color:#324E60; margin:0; font-size:16px; font-weight:400; letter-spacing:-0.32px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">Lines open 8am - 8pm</p>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td valign="top" width="50"></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td valign="top" height="30"></td>
                </tr>
                <!-- HEADER END -->
                <!-- VALUATION BLOCK -->
                <tr>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <tr>
                                <td valign="top" width="50"></td>
                                <td valign="top">
                                    <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                        <tr>
                                            <td background="/images/valuation-background-image.png" bgcolor="#324E60" valign="bottom" style="border-radius: 10px 10px 0px 0px;" height="175">
                                                <!--[if gte mso 9]>
                                                <v:rect xmlns:v="urn:schemas-microsoft-com:vml" fill="true" stroke="false" style="mso-width-percent:1000; height:175px;">
                                                    <v:fill type="tile" src="/images/valuation-background-image.png" color="#324E60" />
                                                    <v:textbox style="mso-fit-shape-to-text:true" inset="0,0,0,0">
                                                <![endif]-->
                                                <div>
                                                    <table cellpadding="40" cellspacing="0" border="0" width="100%">
                                                        <tr>
                                                            <td valign="top" align="left">
                                                                <p style="color:#FFFFFF; margin:0; font-size:40px; font-weight:700; letter-spacing:-0.8px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">Your valuation</p>
                                                            </td>
                                                            <td valign="top" align="right">
                                                                <p style="color:#FFFFFF; margin:0; font-size:40px; font-weight:700; letter-spacing:-0.8px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">£77,250</p>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                                <!--[if gte mso 9]>
                                                </v:textbox>
                                                </v:rect>
                                                <![endif]-->
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top" height="20" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                                        </tr>
                                        <tr>
                                            <td valign="top">
                                                <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                                    <tr>
                                                        <td valign="top" width="40" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                                                        <td valign="top">
                                                            <table cellpadding="0" cellspacing="0" border="0" width="100%" bgcolor="#F2F5F7" style="background-color:#F2F5F7;">
                                                                <tr>
                                                                    <td valign="top">
                                                                        <p style="color:#324E60; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                            Vehicle
                                                                        </p>
                                                                    </td>
                                                                    <td valign="top">
                                                                        <p style="color:#324E60; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                            2018 Porsche 911 991 Carrera GTS Convertible
                                                                        </p>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td valign="top" height="10"></td>
                                                                </tr>
                                                                <tr>
                                                                    <td valign="top">
                                                                        <p style="color:#324E60; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                            Mileage
                                                                        </p>
                                                                    </td>
                                                                    <td valign="top">
                                                                        <p style="color:#324E60; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                            20,000 miles
                                                                        </p>
                                                                    </td>
                                                                </tr>
                                                                <td valign="top" height="10"></td>
                                                                <tr>
                                                                    <td valign="top">
                                                                        <p style="color:#324E60; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                            Registration
                                                                        </p>
                                                                    </td>
                                                                    <td valign="top">
                                                                        <p style="color:#324E60; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                            DN60 VUW
                                                                        </p>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                        <td valign="top" width="40" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top" height="20" bgcolor="#F2F5F7" style="background-color:#F2F5F7;border-radius:0px 0px 10px 10px;"></td>
                                        </tr>
                                    </table>
                                </td>
                                <td valign="top" width="50"></td>
                            </tr>
                            <tr>
                                <td valign="top" height="50"></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <!-- END OF VALUATION BLOCK -->
                <!-- ALERT BLOCK -->
                <tr>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <tr>
                                <td valign="top" width="50"></td>
                                <td valign="top">
                                    <table cellpadding="30" cellspacing="0" border="0" width="100%" bgcolor="#00B67A" style="background-color:#00B67A;border-radius:10px;">
                                        <tr>
                                            <td valign="top" align="center">
                                                <table cellpadding="0" cellspacing="0" border="0" align="center">
                                                    <tr>
                                                        <td valign="middle" align="center">
                                                            <img class="imageFix" src="/images/icons/circle-check.png" alt="Circle Check" title="Circle Check" width="58" height="58" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                                        </td>
                                                        <td valign="middle" width="10"></td>
                                                        <td valign="middle" align="center">
                                                            <h1 style="color:#FFFFFF !important; margin:0; font-size:32px; font-weight:600; letter-spacing:-0.6px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Thank you for your enquiry
                                                            </h1>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td valign="top" width="50"></td>
                            </tr>
                            <tr>
                                <td valign="top" height="50"></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <!-- END OF ALERT BLOCK -->
                <!-- CONTENT AREA -->
                <tr>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <tr>
                                <td valign="top" width="50"></td>
                                <td valign="top">
                                    <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                                        <tr>
                                            <td valign="top">
                                                <h2 style="color:#324E60; margin:0 0 10px; font-size:32px; line-height:36px; font-weight:700; letter-spacing:-0.64px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                    What happens next?
                                                </h2>

                                                <p style="color:#324E60; margin:0 0 20px; font-size:18px; font-weight:600; line-height:24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                    Your request has now been passed to the appropriate department and a representative will aim to get back to you within 30 minutes (during opening hours).
                                                </p>

                                                <h3 style="color:#324E60; margin:0 0 10px; font-size:24px; line-height:28px; font-weight:700; letter-spacing:-0.48px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                    Get in touch. We’re here to help.
                                                </h3>

                                                <p style="color:#324E60; margin:0 0 20px; font-size:18px; font-weight:400; line-height:26px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                    Nunc sapien eros, placerat et placerat eu, vulputate vitae quam. Aenean laoreet justo eu lorem luctus consequat. Nunc convallis libero vitae commodo maximus. Nunc convallis, nisi eget aliquam placerat, dui enim egestas augue, non vehicula justo eros eu arcu. Sed sed nunc eu quam aliquet vestibulum. Aliquam porttitor nisl velit, at ultricies sem convallis nec. Nulla facilisi.
                                                </p>

                                                <p style="color:#324E60; margin:0 0 20px; font-size:18px; font-weight:400; line-height:26px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                    Nunc sapien eros, placerat et placerat eu, vulputate vitae quam. Aenean laoreet justo eu lorem luctus consequat. Nunc convallis libero vitae commodo maximus. Nunc convallis, nisi eget aliquam placerat, dui enim egestas augue, non vehicula justo eros eu arcu. Sed sed nunc eu quam aliquet vestibulum. Aliquam porttitor nisl velit, at ultricies sem convallis nec. Nulla facilisi.
                                                </p>
                                            </td>
                                        </tr>
                                        <!-- OPENING TIMES -->
                                        <tr>
                                            <td valign="top">
                                                <table cellpadding="0" cellspacing="0" border="0" align="left">
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:600; line-height:24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Monday - Friday
                                                            </p>
                                                        </td>

                                                        <td valign="top" width="20"></td>

                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:600; line-height:24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                08:00 - 21:00
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:600; line-height:24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Saturday
                                                            </p>
                                                        </td>

                                                        <td valign="top" width="20"></td>

                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:600; line-height:24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                08:00 - 17:00
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:600; line-height:24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Sunday
                                                            </p>
                                                        </td>

                                                        <td valign="top" width="20"></td>

                                                        <td valign="top">
                                                            <p style="color:#324E60; margin:0; font-size:18px; font-weight:600; line-height:24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                08:00 - 17:00
                                                            </p>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <!-- END OF OPENING TIMES -->
                                    </table>
                                </td>
                                <td valign="top" width="50"></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td valign="top" height="50"></td>
                </tr>
                <!-- END OF CONTENT AREA -->
                <!-- BUTTONS -->
                <tr>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <tr>
                                <td valign="top" width="50"></td>
                                <td valign="top">
                                    <table cellpadding="0" cellspacing="0" border="0" align="left" width="400">
                                        <tr>
                                            <td align="center" style="border-radius: 5px; background-color: #00B67A;">
                                                <a rel="noopener" href="https://vehicle-page-url.co.uk?journey=reserve" target="_blank" style="font-size: 22px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; color: #FFFFFF; font-weight: 700; text-decoration: none;border-radius: 5px; padding: 16px 18px; border: 1px solid #00B67A; display: inline-block;">
                                                    Reserve for £99 <br />
                                                    <span style="color:#FFFFFF; margin:0; font-size:12px; font-weight:600; letter-spacing:-0.24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">Fully refundable deposit</span>
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top" height="12"></td>
                                        </tr>
                                        <tr>
                                            <td align="center" style="border-radius: 5px; background-color: #FF981F;">
                                                <a rel="noopener" href="https://vehicle-page-url.co.uk?journey=finance" target="_blank" style="font-size: 22px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; color: #FFFFFF; font-weight: 700; text-decoration: none;border-radius: 5px; padding: 14px 18px; border: 1px solid #FF981F; display: inline-block;">
                                                    <img class="imageFix" src="/images/icons/shield.png" alt="Shield" title="Shield" width="19" height="19" style="display:inline-block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" /> Check Finance <br />
                                                    <span style="color:#FFFFFF; margin:0; font-size:12px; font-weight:600; letter-spacing:-0.24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">No Impact on Credit Score</span>
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top" height="12"></td>
                                        </tr>
                                        <tr>
                                            <td align="center" style="border-radius: 5px; background-color: #1A98FB;">
                                                <a rel="noopener" href="https://vehicle-page-url.co.uk?journey=enquiry" target="_blank" style="font-size: 22px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; color: #FFFFFF; font-weight: 700; text-decoration: none;border-radius: 5px; padding: 26px 18px; border: 1px solid #1A98FB; display: inline-block;">
                                                    Enquire Now
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top" height="12"></td>
                                        </tr>
                                        <tr>
                                            <td align="center" style="border-radius: 5px; background-color: #324E60;">
                                                <a rel="noopener" href="#" target="_blank" style="font-size: 22px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; color: #FFFFFF; font-weight: 600; text-decoration: none;border-radius: 5px; padding: 26px 18px; border: 1px solid #324E60; display: inline-block;">
                                                    Button Style
                                                </a>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td valign="top" width="50"></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td valign="top" height="40"></td>
                </tr>
                <!-- END OF BUTTONS -->
            </table>
            <!-- END OF INNER WRAPPER -->
        </td>
    </tr>
    <!-- START OF FOOTER -->
    <tr>
        <td valign="top" height="50"></td>
    </tr>
    <tr>
        <td valign="top">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="940">
                            <tr>
                                <td valign="top" width="65"></td>
                                <td valign="top">
                                    <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                                        <tr>
                                            <td valign="top" align="left">
                                                <a href="/" target="_blank" title="Prestige Cars Kent" style="text-decoration: none;">
                                                    <img class="imageFix" src="/images/logo.png" alt="Logo" title="Prestige Cars Kent" width="144" height="85" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                                </a>
                                            </td>
                                            <td valign="top" align="right">
                                                <table cellpadding="0" cellspacing="0" border="0" align="right">
                                                    <tr>
                                                        <td valign="top" align="right" width="60">
                                                            <a href="/" target="_blank" title="Facebook" style="text-decoration: none;">
                                                                <img class="imageFix" src="/images/social/facebook-logo.png" alt="Facebook" title="Facebook" width="60" height="60" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                                            </a>
                                                        </td>

                                                        <td valign="top" align="right" width="8"></td>

                                                        <td valign="top" align="right" width="60">
                                                            <a href="/" target="_blank" title="X" style="text-decoration: none;">
                                                                <img class="imageFix" src="/images/social/x-twitter-logo.png" alt="X" title="X" width="60" height="60" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                                            </a>
                                                        </td>

                                                        <td valign="top" align="right" width="8"></td>


                                                        <td valign="top" align="right" width="60">
                                                            <a href="/" target="_blank" title="Linked In" style="text-decoration: none;">
                                                                <img class="imageFix" src="/images/social/linked-in-logo.png" alt="Linked In" title="Linked In" width="60" height="60" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                                            </a>
                                                        </td>

                                                        <td valign="top" align="right" width="8"></td>


                                                        <td valign="top" align="right" width="60">
                                                            <a href="/" target="_blank" title="Instagram" style="text-decoration: none;">
                                                                <img class="imageFix" src="/images/social/insta-logo.png" alt="Instagram" title="Instagram" width="60" height="60" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                                            </a>
                                                        </td>

                                                        <td valign="top" align="right" width="8"></td>


                                                        <td valign="top" align="right" width="60">
                                                            <a href="/" target="_blank" title="YouTube" style="text-decoration: none;">
                                                                <img class="imageFix" src="/images/social/yt-logo.png" alt="YouTube" title="YouTube" width="60" height="60" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                                            </a>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top" height="20"></td>
                                        </tr>
                                        <tr>
                                            <td valign="top" align="left">
                                                <p style="color:#324E60; margin:0; font-size:16px; font-weight:500; line-height:24px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                    Prestige Cars Kent, <br />
                                                    Hewitts Road, Orpington, <br/>
                                                    Kent, BR6 7QR <br />
                                                    01689 660 660
                                                </p>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td valign="top" width="65"></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td valign="top" height="30"></td>
                </tr>
                <tr>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="940">
                            <tr>
                                <td valign="top" height="1" bgcolor="#A0A6B5" style="background-color:#A0A6B5;"></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td valign="top" height="30"></td>
                </tr>
                <tr>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="940">
                            <tr>
                                <td valign="top" width="65"></td>
                                <td valign="top" align="center">
                                    <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                                        <tr>
                                            <td valign="top" align="center">
                                                <p style="color:#324E60; margin:0; font-size:14px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                    Visit us online at <a href="https://www.prestigecarskent.co.uk" target="_blank" style="color:#324E60; text-decoration: underline;">www.prestigecarskent.co.uk</a>
                                                </p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top" height="20"></td>
                                        </tr>
                                        <tr>
                                            <td valign="top" align="center">
                                                <p style="color:#324E60; margin:0; font-size:12px; font-weight:500; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec et purus sollicitudin, ultricies lorem vel, lacinia odio. Morbi nec sapien et nisi ornare luctus et convallis quam. Sed at augue odio. Nam sed massa a eros imperdiet dapibus ac eget nunc. Nullam consequat posuere lacus at feugiat. Praesent semper justo ac luctus ultricies. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec et purus sollicitudin, ultricies lorem vel, lacinia odio. Morbi nec sapien et nisi ornare luctus et convallis quam. Sed at augue odio. Nam sed massa a eros imperdiet dapibus ac eget nunc. Nullam consequat posuere lacus at feugiat. Praesent semper justo ac luctus ultricies.
                                                </p>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td valign="top" width="65"></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td valign="top" height="50"></td>
    </tr>
    <!-- END OF FOOTER -->
</table>
<!-- End of wrapper table -->
</body>
</html>
