<?php

namespace Mtc\VehicleReservations\Facades;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Facade;
use Mtc\ContentManager\Contracts\Media as MediaModel;
use Mtc\ContentManager\Contracts\MediaFolder;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\MediaRepository;
use Mtc\VehicleReservations\Reservation as ReservationModel;
use Mtc\VehicleReservations\ReservationRepository;

/**
 * Class Reservation
 *
 * ReservationRepository class Facade
 *
 * @method static ReservationModel create(array $data)
 * @see ReservationRepository
 */
class Reservation extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'reservation_repository';
    }
}
