<?php

namespace Mtc\VehicleReservations\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\Crm\Models\Enquiry;
use Mtc\VehicleReservations\Reservation;

class ReservationFactory extends Factory
{
    /**
     * Model
     *
     * @var string
     */
    protected $model = Reservation::class;

    /**
     * Define the model's default state.
     *
     * @return array
     * @throws \Exception
     */
    public function definition()
    {
        return [
            'confirmed_at' => random_int(0, 1) ? Carbon::now()->subMinutes(random_int(0, 2000)) : null,
            'confirmation_sent_at' => random_int(0, 1) ? Carbon::now()->subMinutes(random_int(0, 2000)) : null,
            'ingested_at' => random_int(0, 1) ? Carbon::now()->subMinutes(random_int(0, 2000)) : null,
            'vehicle_id' => random_int(1, 100),
            'customer_id' => random_int(0, 10) ?: null,
            'reference' => Str::random(10),
            'status' => random_int(0, 5),
            'amount' => random_int(5, 500),
            'amount_ex_vat' => random_int(4, 400),
            'currency' => 'gbp',
            'email' => $this->faker->safeEmail(),
            'name' => $this->faker->name() . ' ' . $this->faker->lastName(),
            'contact_number' => $this->faker->phoneNumber(),
            'data' => [],
        ];
    }
}
