<?php

namespace Mtc\VehicleReservations\Listeners;

use Mtc\Checkout\Events\PaidInvoice;
use Mtc\VehicleReservations\Reservation;
use Mtc\VehicleReservations\ReservationRepository;

class ConfirmReservationOnInvoicePayment
{
    /**
     * Create the event listener.
     */
    public function __construct(private readonly ReservationRepository $repository)
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(PaidInvoice $event): void
    {
        if ($event->invoice->isPaid() && $event->invoice->getPayable() instanceof Reservation) {
            $this->repository->addEmailWhenRequired($event->invoice->getPayable(), $event->invoice->getEmail());
            $this->repository->markConfirmed($event->invoice->getPayable(), $event->payment_details['amount']);
        }
    }
}
