<?php

namespace Mtc\VehicleReservations;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\ServiceProvider;
use Mtc\VehicleReservations\Console\Commands\IngestReservations;

class ReservationProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/reservations.php', 'reservations');
        $this->app->register(ReservationEventProvider::class);

        Relation::morphMap([
            'reservation' => Reservation::class,
        ]);
    }

    public function boot()
    {
        $this->app->bind('reservation_repository', ReservationRepository::class);

        $this->loadViewsFrom(dirname(__DIR__, 1) . '/resources/views', 'reservations');
        $this->loadTranslationsFrom(dirname(__DIR__, 1) . '/resources/lang', 'reservations');

        $this->commands([
            IngestReservations::class,
        ]);
    }
}
