<?php

namespace Mtc\VehicleReservations\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\VehicleReservations\Reservation;
use Mtc\VehicleReservations\ReservationRepository;

class ReservationFlowController
{

    public function create(Request $request, Vehicle $vehicle, ReservationRepository $repository)
    {
        $data = $request->input();
        $data['vehicle_id'] = $vehicle->id;
        /** @var Reservation $reservation */
        $reservation = $repository->create($data);
        $reservation['config'] = [
            'invoice_id' => $repository->createInvoice($reservation)->getId(),
            'stripe_public_key' => App::make(config('stripe.config'))->publicKey(),
            'customer' => null,
        ];
        return $reservation;
    }

    public function update(Request $request, Reservation $reservation, ReservationRepository $repository)
    {
        return $repository->updateDetails($reservation, $request->input());
    }

    public function destroy(Reservation $reservation)
    {

    }
}
