<?php

namespace Mtc\VehicleReservations\Jobs;

use Carbon\Carbon;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Mtc\Crm\Contracts\EnquiryActionModel;
use Mtc\Crm\Facades\Enquiries;
use Mtc\VehicleReservations\Reservation;

class ProcessIncomingReservationJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected Reservation $reservation)
    {
        $this->onQueue('emails');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if ($this->process()) {
            $this->reservation->refresh()->update([
                'ingested_at' => Carbon::now(),
            ]);
        }
    }

    private function process(): bool
    {
        return $this->sendConfirmation();
    }

    private function sendConfirmation(): bool
    {
        if (!empty($this->reservation->confirmation_sent_at)) {
            return true;
        }

        try {
            $class = config('reservations.reservation_confirmation_mail');
            Mail::to($this->reservation->email)->send(new $class($this->reservation));
            $this->reservation->refresh()
                ->update([
                    'confirmation_sent_at' => now(),
                ]);
            return true;
        } catch (\Exception $exception) {
            Log::warning($exception->getMessage());
            return false;
        }
    }
}
