<?php

namespace Mtc\VehicleReservations\Http\Controllers;

use App\Facades\Settings;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\VehicleReservations\Http\Requests\ReservationRequest;
use Mtc\VehicleReservations\Reservation;
use Mtc\VehicleReservations\ReservationRepository;

class ReservationFlowController
{
    public function create(ReservationRequest $request, Vehicle $vehicle, ReservationRepository $repository)
    {
        $data = $request->input();
        $data['vehicle_id'] = $vehicle->id;
        /** @var Reservation $reservation */
        $reservation = $repository->create($data);
        $invoice_repository = $repository->createInvoice($reservation);
        $reservation['config'] = $repository->getPaymentConfig($reservation, $invoice_repository);
        return $reservation;
    }

    public function update(
        ReservationRequest $request,
        Reservation $reservation,
        ReservationRepository $repository
    ): Reservation {
        return $repository->updateDetails($reservation, $request->input());
    }
}
