<?php

namespace Mtc\VehicleSavings;

use App\Facades\Settings;
use Mtc\VehicleSavings\Contracts\SavingsCalculator;

class VehicleSavingsHelper
{
    public static function getEnabledCalculator(): SavingsCalculator
    {
        return (new self())->initialize();
    }

    public function initialize(): SavingsCalculator
    {
        return match (Settings::get('vehicle-savings-type')) {
            'peter-vardy' => new SavingsCalculatorPeterVardy(),
            default => new SavingsCalculatorDefault()
        };
    }
}
