<?php

namespace Mtc\VehicleSavings;

use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Mtc\MercuryDataModels\Events\LoadVehicleDataFields;
use Mtc\VehicleSavings\Listeners\AddSavingsToVehicleFields;

class SavingsProvider extends EventServiceProvider
{
    protected $listen = [
        LoadVehicleDataFields::class => [
            AddSavingsToVehicleFields::class
        ]
    ];
    public function boot()
    {
        parent::register();
        $this->loadTranslationsFrom(dirname(__DIR__) . '/resources/lang', 'savings');
    }
}
