<?php

namespace Mtc\VehicleValuation\Config;

use GuzzleHttp\Client;

class BCAConfig
{
    public function __construct(public Client $client)
    {
    }

    public function enabled(): bool
    {
        return !empty($this->apiKey()) && !empty($this->apiSecret());
    }

    public function apiKey(): string
    {
        return config('valuation.drivers.bca.api_key');
    }

    public function apiSecret(): string
    {
        return config('valuation.drivers.bca.api_secret');
    }

    public function live(): bool
    {
        return config('valuation.drivers.bca.live');
    }

    public function getAuthEndpoint()
    {
        return 'https://login.microsoftonline.com/ffbeab18-cefa-4aaf-9554-75a0af201128/oauth2/v2.0/token';
    }

    public function getEndpoint($vrm)
    {
        if($this->live()){
            return 'https://bca-apim-prod-gateway.api.bca.com/onlinevaluation/api/vehicles/'.$vrm.'/';
        } else {
            return 'https://bca-apim-uat-gateway.api.bca.com/onlinevaluation/api/vehicles/'.$vrm.'/';
        }
    }

    public function getScope()
    {
        if($this->live()){
            return 'api://5b2d3727-3cb6-41d1-b5f0-4f40eb32c8a1/.default';
        } else {
            return 'api://432fa31d-24ea-4b32-a63f-6a31e3d89b14/.default';
        }
    }
}
