<?php

namespace Mtc\VehicleValuation\Providers;

use Illuminate\Support\ServiceProvider;

class ValuationProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/valuation.php', 'valuation');

        parent::register();

        if (config('valuation.auto_load_migrations')) {
            $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations/');
        }
    }

    public function boot()
    {
        $this->app->bind('valuation-repository', config('valuation.repository'));

        $this->loadViewsFrom(
            dirname(__DIR__, 2) . '/resources/views',
            'valuation'
        );

        $this->publishes([
            dirname(__DIR__, 2) . '/resources/views' => resource_path('views/vendor/valuation'),
        ], 'views');
    }
}
